/*
 *  App GUI global defaults:
 *  This file is used privately by the widgets in the gui/ directory.
 *  The symbols it exports should not be visible anywhere else.
 */

#if defined(USE_WINDOWS_98_LOOK)

#define BACKGROUND			LIGHT_GREY
#define FILL_ITEM			WHITE
#define ENABLED_ITEM			BLACK
#define DISABLED_ITEM			GREY
#define FOCUS_BORDER			BLACK
#define UPPER_LEFT			WHITE
#define LOWER_RIGHT			GREY

#define RADIO_BUTTON_UPPER		LOWER_RIGHT
#define RADIO_BUTTON_LOWER		PALE_GREY
#define RADIO_BUTTON_INNER_UPPER	ENABLED_ITEM
#define RADIO_BUTTON_INNER_LOWER	UPPER_LEFT

#define SCROLL_THUMB_FILL		LIGHT_GREY
#define SCROLL_BACKGROUND		PALE_GREY

#define MENU_BAR_BACKGROUND		BACKGROUND
#define MENU_BAR_HILIGHT		BACKGROUND
#define MENU_BACKGROUND			BACKGROUND
#define MENU_LEFT_FILL			CLEAR
#define MENU_TEXT			BLACK
#define MENU_TEXT_HILIGHT		BACKGROUND
#define MENU_OUTER_BORDER		BLACK
#define MENU_UPPER_BORDER		WHITE
#define MENU_LOWER_BORDER		GREY
#define MENU_HILIGHT			rgb(0,0,128)
#define MENU_ITEM_UPPER_BORDER		CLEAR
#define MENU_ITEM_LOWER_BORDER		CLEAR

#elif defined(USE_WINDOWS_XP_LOOK)

#define BACKGROUND			rgb(239,237,222)
#define FILL_ITEM			WHITE
#define ENABLED_ITEM			BLACK
#define DISABLED_ITEM			GREY
#define FOCUS_BORDER			BLACK
#define UPPER_LEFT			WHITE
#define LOWER_RIGHT			rgb(240,236,215)

#define RADIO_BUTTON_UPPER		LOWER_RIGHT
#define RADIO_BUTTON_LOWER		FILL_ITEM
#define RADIO_BUTTON_INNER_UPPER	ENABLED_ITEM
#define RADIO_BUTTON_INNER_LOWER	UPPER_LEFT

#define SCROLL_THUMB_FILL		rgb(194,211,252)
#define SCROLL_BACKGROUND		rgb(245,244,239)

#define MENU_BAR_BACKGROUND		rgb(239,237,222)
#define MENU_BAR_HILIGHT		rgb(239,237,222)
#define MENU_BACKGROUND			rgb(252,252,249)
#define MENU_LEFT_FILL			MENU_BAR_HILIGHT
#define MENU_TEXT			BLACK
#define MENU_TEXT_HILIGHT		BLACK
#define MENU_OUTER_BORDER		rgb(138,134,122)
#define MENU_UPPER_BORDER		CLEAR
#define MENU_LOWER_BORDER		CLEAR
#define MENU_HILIGHT			rgb(193,210,238)
#define MENU_ITEM_UPPER_BORDER		rgb(49,106,197)
#define MENU_ITEM_LOWER_BORDER		MENU_ITEM_UPPER_BORDER

#else	/* USE_GRAPHAPP_LOOK which is the default */

#define BACKGROUND			PALE_GREY
#define FILL_ITEM			WHITE
#define ENABLED_ITEM			BLACK
#define DISABLED_ITEM			GREY
#define FOCUS_BORDER			BLACK
#define UPPER_LEFT			WHITE
#define LOWER_RIGHT			GREY

#define RADIO_BUTTON_UPPER		LOWER_RIGHT
#define RADIO_BUTTON_LOWER		PALE_GREY
#define RADIO_BUTTON_INNER_UPPER	ENABLED_ITEM
#define RADIO_BUTTON_INNER_LOWER	UPPER_LEFT

#define SCROLL_THUMB_FILL		PALE_GREY
#define SCROLL_BACKGROUND		LIGHT_GREY

#define MENU_BAR_BACKGROUND		BACKGROUND
#define MENU_BAR_HILIGHT		rgb(193,210,238)
#define MENU_BACKGROUND			BACKGROUND
#define MENU_LEFT_FILL			CLEAR
#define MENU_TEXT			BLACK
#define MENU_TEXT_HILIGHT		BLACK
#define MENU_OUTER_BORDER		rgb(138,134,122)
#define MENU_UPPER_BORDER		CLEAR
#define MENU_LOWER_BORDER		CLEAR
#define MENU_HILIGHT			rgb(193,210,238)
#define MENU_ITEM_UPPER_BORDER		rgb(49,106,197)
#define MENU_ITEM_LOWER_BORDER		MENU_ITEM_UPPER_BORDER

#endif

