
ALL : GraphApp.lib

CPP=cl.exe /nologo
CPP_PROJ=/MD /W3 /GX /O2 /YX /FD /c \
	/DWIN32 /D_WINDOWS /DNDEBUG /D_MBCS /D_LIB \
	/I.. /I..\WIN32 /I..\LIBZ /I..\LIBPNG /I..\LIBJPEG /I..\LIBGIF \
	/I..\GUI /I..\UTILITY
	
LNK32=link.exe /nologo /out:
LNK32_FLAGS=kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /subsystem:windows /incremental:no /machine:I386

LIB32=link.exe -lib /nologo /out:
LIB32_FLAGS=

UTILITY= \
	APPUTIL.OBJ \
	ARRAY.OBJ \
	BORDER.OBJ \
	CLIPLINE.OBJ \
	COMPOSE.OBJ \
	CONTROL.OBJ \
	DELETING.OBJ \
	DISPATCH.OBJ \
	DRAWIMG.OBJ \
	DRAWING.OBJ \
	DRAWTEXT.OBJ \
	FONTUTIL.OBJ \
	IMAGE.OBJ \
	IMGLIST.OBJ \
	MALLOC.OBJ \
	PALETTE.OBJ \
	POINT.OBJ \
	RECT.OBJ \
	REGION.OBJ \
	RESOURCE.OBJ \
	RGB.OBJ \
	STR.OBJ \
	STRTABLE.OBJ \
	UTF8.OBJ \
	UTF8REGX.OBJ \
	WINUTIL.OBJ

GUI= \
	BUTTON.OBJ \
	CHECKBOX.OBJ \
	CURSORS.OBJ \
	DIALOG.OBJ \
	DROPFLD.OBJ \
	DROPLIST.OBJ \
	FIELD.OBJ \
	IMAGEBTN.OBJ \
	IMGLABEL.OBJ \
	LABEL.OBJ \
	LISTBOX.OBJ \
	MANAGER.OBJ \
	MENU.OBJ \
	NOTEBTN.OBJ \
	PASSFLD.OBJ \
	RADIOBTN.OBJ \
	SCROLL.OBJ \
	SEPARAT.OBJ \
	SPLITTER.OBJ \
	TABBTN.OBJ \
	TEXTBOX.OBJ \
	TEXTUNDO.OBJ \
	TIP.OBJ

WIN32= \
	BMAP.OBJ \
	BMAPIMG.OBJ \
	CURSOR.OBJ \
	CLIPBRD.OBJ \
	DRAWBMAP.OBJ \
	DRAWWIN.OBJ \
	EVENT.OBJ \
	FOLDER.OBJ \
	FONT.OBJ \
	GRAPHICS.OBJ \
	INIT.OBJ \
	TIMER.OBJ \
	WIN.OBJ

IMGFMT= \
	IMGREAD.OBJ \
	IMGWRITE.OBJ \
	READGIF.OBJ \
	READH.OBJ \
	READJPG.OBJ \
	READPNG.OBJ \
	WRITEGIF.OBJ \
	WRITEH.OBJ \
	WRITEJPG.OBJ \
	WRITEPNG.OBJ

LIBZ= \
	ADLER32.OBJ \
	COMPRESS.OBJ \
	CRC32.OBJ \
	DEFLATE.OBJ \
	INFBACK.OBJ \
	INFFAST.OBJ \
	INFLATE.OBJ \
	INFTREES.OBJ \
	TREES.OBJ \
	UNCOMPR.OBJ \
	ZUTIL.OBJ \

LIBPNG= \
	PNG.OBJ \
	PNGERROR.OBJ \
	PNGGET.OBJ \
	PNGMEM.OBJ \
	PNGPREAD.OBJ \
	PNGREAD.OBJ \
	PNGRIO.OBJ \
	PNGRTRAN.OBJ \
	PNGRUTIL.OBJ \
	PNGSET.OBJ \
	PNGTRANS.OBJ \
	PNGWIO.OBJ \
	PNGWRITE.OBJ \
	PNGWTRAN.OBJ \
	PNGWUTIL.OBJ

LIBJPEG= \
	JCAPIMIN.OBJ \
	JCAPISTD.OBJ \
	JCCOEFCT.OBJ \
	JCCOLOR.OBJ \
	JCDCTMGR.OBJ \
	JCHUFF.OBJ \
	JCINIT.OBJ \
	JCMAINCT.OBJ \
	JCMARKER.OBJ \
	JCMASTER.OBJ \
	JCOMAPI.OBJ \
	JCPARAM.OBJ \
	JCPHUFF.OBJ \
	JCPREPCT.OBJ \
	JCSAMPLE.OBJ \
	JCTRANS.OBJ \
	JDAPIMIN.OBJ \
	JDAPISTD.OBJ \
	JDATADST.OBJ \
	JDATASRC.OBJ \
	JDCOEFCT.OBJ \
	JDCOLOR.OBJ \
	JDDCTMGR.OBJ \
	JDHUFF.OBJ \
	JDINPUT.OBJ \
	JDMAINCT.OBJ \
	JDMARKER.OBJ \
	JDMASTER.OBJ \
	JDMERGE.OBJ \
	JDPHUFF.OBJ \
	JDPOSTCT.OBJ \
	JDSAMPLE.OBJ \
	JDTRANS.OBJ \
	JERROR.OBJ \
	JFDCTFLT.OBJ \
	JFDCTFST.OBJ \
	JFDCTINT.OBJ \
	JIDCTFLT.OBJ \
	JIDCTFST.OBJ \
	JIDCTINT.OBJ \
	JIDCTRED.OBJ \
	JMEMMGR.OBJ \
	JMEMNOBS.OBJ \
	JQUANT1.OBJ \
	JQUANT2.OBJ \
	JUTILS.OBJ

LIBGIF= \
	GIF.OBJ

LIB32_OBJS= \
	$(UTILITY) $(GUI) $(WIN32) $(IMGFMT) \
	$(LIBZ) $(LIBPNG) $(LIBJPEG) $(LIBGIF)
GraphApp.lib : $(LIB32_OBJS)
    $(LIB32)GraphApp.lib $(LIB32_FLAGS) $(LIB32_OBJS)

SOURCE=..\LIBZ\ADLER32.C
ADLER32.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\APPUTIL.C
APPUTIL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\ARRAY.C
ARRAY.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\BORDER.C
BORDER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\BMAP.C
BMAP.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\BMAPIMG.C
BMAPIMG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\BUTTON.C
BUTTON.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\CHECKBOX.C
CHECKBOX.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\CLIPBRD.C
CLIPBRD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\CURSOR.C
CURSOR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\CLIPLINE.C
CLIPLINE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\COMPOSE.C
COMPOSE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\COMPRESS.C
COMPRESS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\CONTROL.C
CONTROL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\CRC32.C
CRC32.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\CURSORS.C
CURSORS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\DEFLATE.C
DEFLATE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\DELETING.C
DELETING.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\DIALOG.C
DIALOG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\DISPATCH.C
DISPATCH.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\DRAWBMAP.C
DRAWBMAP.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\DRAWIMG.C
DRAWIMG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\DRAWING.C
DRAWING.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\DRAWTEXT.C
DRAWTEXT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\DRAWWIN.C
DRAWWIN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\DROPFLD.C
DROPFLD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\DROPLIST.C
DROPLIST.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\EVENT.C
EVENT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\FIELD.C
FIELD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\FOLDER.C
FOLDER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\FONT.C
FONT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\FONTUTIL.C
FONTUTIL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBGIF\GIF.C
GIF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\GRAPHICS.C
GRAPHICS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\IMAGE.C
IMAGE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\IMAGEBTN.C
IMAGEBTN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\IMGLABEL.C
IMGLABEL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\IMGLIST.C
IMGLIST.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\IMGREAD.C
IMGREAD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\IMGWRITE.C
IMGWRITE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\INFBACK.C
INFBACK.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\INFFAST.C
INFFAST.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\INFLATE.C
INFLATE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\INFTREES.C
INFTREES.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\INIT.C
INIT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCAPIMIN.C
JCAPIMIN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCAPISTD.C
JCAPISTD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCCOEFCT.C
JCCOEFCT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCCOLOR.C
JCCOLOR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCDCTMGR.C
JCDCTMGR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCHUFF.C
JCHUFF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCINIT.C
JCINIT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCMAINCT.C
JCMAINCT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCMARKER.C
JCMARKER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCMASTER.C
JCMASTER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCOMAPI.C
JCOMAPI.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCPARAM.C
JCPARAM.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCPHUFF.C
JCPHUFF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCPREPCT.C
JCPREPCT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCSAMPLE.C
JCSAMPLE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JCTRANS.C
JCTRANS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDAPIMIN.C
JDAPIMIN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDAPISTD.C
JDAPISTD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDATADST.C
JDATADST.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDATASRC.C
JDATASRC.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDCOEFCT.C
JDCOEFCT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDCOLOR.C
JDCOLOR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDDCTMGR.C
JDDCTMGR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDHUFF.C
JDHUFF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDINPUT.C
JDINPUT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDMAINCT.C
JDMAINCT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDMARKER.C
JDMARKER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDMASTER.C
JDMASTER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDMERGE.C
JDMERGE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDPHUFF.C
JDPHUFF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDPOSTCT.C
JDPOSTCT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDSAMPLE.C
JDSAMPLE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JDTRANS.C
JDTRANS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JERROR.C
JERROR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JFDCTFLT.C
JFDCTFLT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JFDCTFST.C
JFDCTFST.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JFDCTINT.C
JFDCTINT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JIDCTFLT.C
JIDCTFLT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JIDCTFST.C
JIDCTFST.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JIDCTINT.C
JIDCTINT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JIDCTRED.C
JIDCTRED.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JMEMMGR.C
JMEMMGR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JMEMNOBS.C
JMEMNOBS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JQUANT1.C
JQUANT1.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JQUANT2.C
JQUANT2.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBJPEG\JUTILS.C
JUTILS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\LABEL.C
LABEL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\LISTBOX.C
LISTBOX.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\MALLOC.C
MALLOC.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\MANAGER.C
MANAGER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\MENU.C
MENU.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\NOTEBTN.C
NOTEBTN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\PALETTE.C
PALETTE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\PASSFLD.C
PASSFLD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNG.C
PNG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGERROR.C
PNGERROR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGGET.C
PNGGET.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGMEM.C
PNGMEM.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGPREAD.C
PNGPREAD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGREAD.C
PNGREAD.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGRIO.C
PNGRIO.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGRTRAN.C
PNGRTRAN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGRUTIL.C
PNGRUTIL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGSET.C
PNGSET.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGTRANS.C
PNGTRANS.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGWIO.C
PNGWIO.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGWRITE.C
PNGWRITE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGWTRAN.C
PNGWTRAN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBPNG\PNGWUTIL.C
PNGWUTIL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\POINT.C
POINT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\RADIOBTN.C
RADIOBTN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\READGIF.C
READGIF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\READH.C
READH.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\READJPG.C
READJPG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\READPNG.C
READPNG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\RECT.C
RECT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\REGION.C
REGION.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\RESOURCE.C
RESOURCE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\RGB.C
RGB.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\SCROLL.C
SCROLL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\SEPARAT.C
SEPARAT.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\SPLITTER.C
SPLITTER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\STR.C
STR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\STRTABLE.C
STRTABLE.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\TABBTN.C
TABBTN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\TEXTBOX.C
TEXTBOX.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\TIMER.C
TIMER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\GUI\TIP.C
TIP.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\TREES.C
TREES.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\UNCOMPR.C
UNCOMPR.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\UTF8.C
UTF8.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\UTF8REGX.C
UTF8REGX.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\WIN32\WIN.C
WIN.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\UTILITY\WINUTIL.C
WINUTIL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\WRITEGIF.C
WRITEGIF.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\WRITEH.C
WRITEH.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\WRITEJPG.C
WRITEJPG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\IMGFMT\WRITEPNG.C
WRITEPNG.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

SOURCE=..\LIBZ\ZUTIL.C
ZUTIL.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

CLEAN :
	@erase *.OBJ *.LIB *.EXE vc60.*

DEMOS : DEMO_1.EXE

LNK32_OBJS= TESTER.OBJ GraphApp.lib
DEMO_1.EXE : $(LNK32_OBJS)
    $(LNK32)DEMO_1.EXE $(LNK32_FLAGS) $(LNK32_OBJS)

SOURCE=..\DEMO\TESTER.C
TESTER.OBJ : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)
